/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.bean.xml.PropertyFileFormat;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.PlatformInfo;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class InstallHelper {
    private static Logger logger = Logger.getLogger(InstallHelper.class.getName());
    public static final String RESPONSE_FILE = "-responseFile";

    public static void runAsyncCommand(String ... cmdAndArgs) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(cmdAndArgs);
        ProcessLaunchInfo pli = new ProcessLaunchInfo(pb, null, null);
        ProcessLauncher.launch((ProcessLaunchInfo)pli);
    }

    public static void setPermission(String execname, String permission) {
        try {
            InstallHelper.runAsyncCommand("chmod", permission, execname);
        }
        catch (Exception e) {
            logger.severe(new DefaultErrorMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_SETPERMISSION_EXCEPTION, new Object[0]).getMessage());
        }
    }

    public static String getInstallBinariesPath() {
        return System.getProperty("oracle.installer.scratchPath") + File.separator + "ext" + File.separator + "bin";
    }

    public static String getInstallLibrariesPath() {
        return System.getProperty("oracle.installer.scratchPath") + File.separator + "ext" + File.separator + "lib";
    }

    public static String getTempLocation() {
        File scratchPath = new File(System.getProperty("oracle.installer.scratchPath"));
        return scratchPath.getParentFile().getAbsolutePath();
    }

    public static void Load(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.exists()) {
            System.load(file.getPath());
        } else {
            logger.severe(file.getPath().toString() + " file not found");
        }
    }

    public static String getValue(String key) {
        String value = InstallHelper.getCmdLineArgValue(key);
        if (value == null && (value = InstallHelper.getResponseFileValue(key)) == null && PlatformInfo.getInstance().getEnv(key) != null && PlatformInfo.getInstance().getEnv(key).length() > 0) {
            return PlatformInfo.getInstance().getEnv(key);
        }
        return value;
    }

    public static String getValueAlt(String key) {
        String value = InstallHelper.getCmdLineArgValue(key);
        if (value == null && (value = InstallHelper.getResponseFileValue(key)) == null && System.getenv(key) != null && System.getenv(key).length() > 0) {
            return System.getenv(key);
        }
        return value;
    }

    public static String getCmdLineArgValue(String key) {
        SetupDriver setupDriver;
        Properties clArgs;
        if (key != null && (clArgs = (setupDriver = SetupDriver.getInstance()).getCommandLineArgs()) != null && clArgs.getProperty(key.toLowerCase()) != null) {
            return clArgs.getProperty(key.toLowerCase());
        }
        return null;
    }

    public static String getResponseFileValue(String key) {
        File responseFile = null;
        List args = Application.getInstance().getArguments();
        int index = -1;
        for (int i = 0; i < args.size(); ++i) {
            if (!((String)args.get(i)).equalsIgnoreCase(RESPONSE_FILE)) continue;
            index = i;
        }
        if (index != -1 && index + 1 < args.size() && !((String)args.get(index + 1)).startsWith("-")) {
            responseFile = new File((String)args.get(index + 1));
        }
        Properties properties = new Properties();
        String path = "";
        if (responseFile != null) {
            path = responseFile.getAbsolutePath();
        }
        try {
            if (path != "") {
                PropertyFileFormat propFormat = new PropertyFileFormat();
                properties = propFormat.loadProperties((InputStream)new FileInputStream(path));
            }
        }
        catch (InvalidPropertiesFormatException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (properties.getProperty(key) != null && properties.getProperty(key).length() > 0) {
            return properties.getProperty(key);
        }
        return null;
    }

    public static String getConfigToolAllCommandsPath(String home) {
        if (home != null && home.trim().length() > 0) {
            return new File(new File(home, "cfgtoollogs").getPath(), OiiolTextLogger.s_sConfigToolCommands).getPath();
        }
        return "";
    }

    public static String getInstallerTimeStamp() {
        return OiiolLoggerUtil.getTimeStamp();
    }
}

